#Demos criar dois grupos de variáveis
# x - variáveis independentes:
## x1 - velocidade de entrega;
## x2 - nível de preço;
## x3 - flexibilidade de preço;
## x4 - imagem do fabricante;
## x5 - serviço geral;
## x6 - imagem da equipe de vendas;
## x7 - qualidade do produto.
X <- as.matrix(hatco[,2:8])
#variáveis dependentes
## x9  - nível de uso;
## x10 - nível de satisfação. 
Y <- as.matrix(hatco[,10:11])
#----------------------------------------------
##       Instalando pacotes  
#----------------------------------------------
# Instalando os pacotes necessário para a 
##  análise de correlação canonica
install.packages("CCA")
# Instalando o pacote para teste de significância das 
## cargas canônicas.
install.packages("CCP")
#-----------------------------------------------
library(CCA)
library(CCP)
#----------------------------------------------------
# Analisando a matriz de correlação entre X e Y
# Podemos ver ambos os vetores X e Y quanto à correlação
## dentro e entre os grupos
# A função utiliza será "matcor()" e depois usamos 
## img.matcor() para representar graficamente
# Calculando a matriz e salvando em "correl"
correl <- matcor(X, Y)
#Exibindo a matriz de correlação
img.matcor(correl, type = 2)
#Interpretação: temos três diagramas. No primeiro temos
## a correlação dentro do graupo de variáveis do grupo X;
## no segundo temos a correlação entre as variáveis do 
## grupo Y e terceiro temos a correlação entre as variáveis
## do grupo Y (na linha) e X (na coluna).
#-----------------------------------------------------
# Para obtermos a correlação canonica devemos usar a função
## cc() do pacote CCA
# cc(X, Y)
## X - matriz numérica (n * p), contendo as coodenadas X
## Y - matriz numérica (n * q), contendo as coodenadas Y
ccyx <- cc(X,Y)
#Vizualizando os objetos salvos em ccyx
names(ccyx)
#Para obtermos a correlação canonica, valvando no objeto v.ca
v.ca <-ccyx$cor
#Imprimindo na tela a correlção canônica entre Uk e Vk
print(v.ca)
# [1] 0.9369129 0.5100225
#A correlação canônica pode ser representada pelo gráfico:
barplot(ccyx$cor, xlab = "Dimensão",
        ylab = "Correlação canônica", names.arg = 1:2, ylim = c(0,1))

#-------------------------------------------------------
# Testes multivariados de significância para ambas 
##  funções canônicas
rho <- ccyx$cor
## Defina o número de observações "n",
## o número de variáveis no primeiro conjunto de dados "p"
## e o número de variáeis no segundo conjunto "q".

n <- dim(hatco)[1]
p <- dim(X)[2]
q <- dim(Y)[2]

#Lambda de Wilks
p.asym(rho, n, p, q, tstat = "Wilks")
#Traço de Pillai
p.asym(rho, n, p, q, tstat = "Pillai")
#Traço de Hoteling
p.asym(rho, n, p, q, tstat = "Hotelling")
#Traço de gcr de Roy
p.asym(rho, n, p, q, tstat = "Roy")

#---------------------------------------------------------
#Proporção da variância total explicada

## Precisaremos das cargas canônicas
# Usamos a função 'comput'
loadings<- comput(X,Y,ccyx)
# em que 'X' é o conj. de variáveis independentes;
#        'Y' o conj. de variáveis dependentes;
#        'ccyx'  são os resultados obtidos anteriormente 
#por meio da função 'cc()'
#Exibindo as cargas canônicas:
print(loadings[3:6])
# O comando utiliza a função 'print()' para imprimir os valores
## armazenados do terceiro ao sexto item da lista salva no 
## objetivo “loadings” acima. 

#PVTE Uk
pvte.u <-(colSums((loadings$corr.X.xscores)^2))/(dim(X)[2])*100

#PVTE Vk
pvte.v <-(colSums((loadings$corr.Y.yscores)^2))/(dim(Y)[2])*100

print(pvte.u)
print(pvte.v)

#----------------------------------------------------------
#Índice de redundância (IR)
# Sintetiza a PVTE e o R² canônico em um único indicador
## R² canônico: indica o quanto da variância da variável 
## canônica dependente é explicada pela variável canônica 
## independente. É  o quadrado da correlação canônica.

# Podemos obter o R² canônico
r2.c <-ccyx$cor^2
#Vizualizando:
print(r2.c)

#Calculando IR para as variáveis canônicas Uk
ir.x <-(colSums((loadings$corr.X.xscores)^2))/(dim(X)[2])*(ccyx$cor^2)
#Calculando IR para as variáveis canônicas Vk
ir.y <-(colSums((loadings$corr.Y.yscores)^2))/(dim(Y)[2])*(ccyx$cor^2)

#Vizualizando IR para Uk e Vk, respectivamente
print(ir.x)
print(ir.y)


#---------------------------------------------------------
# Coeficientes padronizados (pesos canônicos)
## para as variáveis dependentes;
sy <- diag(sqrt(diag(cov(Y))))
sy %*% ccyx$ycoef

# Coeficientes padronizados (pesos canônicos) 
## para as variáveis independentes;
sx <- diag(sqrt(diag(cov(X))))
sx %*% ccyx$xcoef

#--------------------------------------------------------
#Cargas canônicas
# Correlação entre as variáveis independentes 
## e suas variáveis canônicas


print(ccyx$scores$corr.X.xscores)
# Correlação entre as variáveis dependentes 
## e suas variáveis canônicas
print(ccyx$scores$corr.Y.yscores)

#Instalando o pacote
#Execute APENAS UMA VEZ!
install.packages("knitr")
#Carregando o pacote. Você deve executar toda vez que reiniciar o R
library(knitr)
#Obtendo as cargas canônicas para a variável estatistica independente
kable(ccyx$scores$corr.X.xscores, 
      col.names = c("Carga canônica U1","Carga canônica U2"))
#Obtendo as cargas canônicas para a variável estatistica dependente
kable(ccyx$scores$corr.Y.yscores, 
      col.names = c("Carga canônica V1","Carga canônica V2"))

#------------------------------------------------------
#Cargas canônicas cruzadas
# Correlação entre as variáveis independentes 
# e variáveis estatísticas canônicas dependentes
ccyx$scores$corr.X.yscores
# Correlação entre as variáveis dependentes 
# e variáveis estatísticas canônicas independentes
ccyx$scores$corr.Y.xscores


ccyx[3:4]



ccyx[3:6]

library(CCA)
plt.cc(ccyx, var.label = TRUE)
detach(package:CCA)

install.packages("vegan")
library(vegan)
cc3 <- cca(X, Y)
plot(cc3, scaling = 1)



